<?php

global $pmServer;
global $pmWorkspace;

$pmServer = "http://10.100.64.7:13300";
$pmWorkspace = "workflow";

// Optional, these values can be here or can be send from case variables - Start
global $pmClientId;
global $pmClientSecret;
global $pmUsername;
global $pmPassword;

$pmClientId = "x-pm-local-client";
$pmClientSecret = "179ad45c6ce2cb97cf1029e212046e81";
$pmUsername = "admin";
$pmPassword = "admin";
// Optional, these values can be here or can be send from case variables - End


function pmRestLogin($clientId, $clientSecret, $username, $password) {
    global $pmServer, $pmWorkspace;
    $postParams = array(
        'grant_type'    => 'password',
        'scope'         => '*',       //set to 'view_process' if not changing the process
        'client_id'     => $clientId,
        'client_secret' => $clientSecret,
        'username'      => $username,
        'password'      => $password
    );

    $ch = curl_init("$pmServer/$pmWorkspace/oauth2/token");
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postParams);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $oToken = json_decode(curl_exec($ch));
    $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpStatus != 200) {
        print "Error in HTTP status code: $httpStatus\n";
        return null;
    }
    elseif (isset($oToken->error)) {
        print "Error logging into $pmServer:\n" .
            "Error:       {$oToken->error}\n" .
            "Description: {$oToken->error_description}\n";
    }
    else {
        //At this point $oToken->access_token can be used to call REST endpoints.

        //If planning to use the access_token later, either save the access_token
        //and refresh_token as cookies or save them to a file in a secure location.

        //If saving them as cookies:
        setcookie("access_token",  $oToken->access_token,  time() + 86400);
        setcookie("refresh_token", $oToken->refresh_token); //refresh token doesn't expire
        setcookie("client_id",     $clientId);
        setcookie("client_secret", $clientSecret);

        //If saving to a file:
        //file_put_contents("/secure/location/oauthAccess.json", json_encode($tokenData));
    }

    return $oToken;
}

function pmRestRefresh($clientId=null, $clientSecret=null, $refreshToken=null) {
    global $pmServer, $pmWorkspace;
    $clientId     = ($clientId === null and isset($_COOKIE['client_id']))         ? $_COOKIE['client_id']     : $clientId;
    $clientSecret = ($clientSecret === null and isset($_COOKIE['client_secret'])) ? $_COOKIE['client_secret'] : $clientSecret;
    $refreshToken = ($refreshToken === null and isset($_COOKIE['refresh_token'])) ? $_COOKIE['refresh_token'] : $refreshToken;

    $aVars = array(
        'grant_type'    => 'refresh_token',
        'client_id'     => $clientId,
        'client_secret' => $clientSecret,
        'refresh_token' => $refreshToken
    );

    $ch = curl_init("$pmServer/$pmWorkspace/oauth2/token");
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $aVars);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $oToken = json_decode(curl_exec($ch));
    $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpStatus != 200) {
        print "Error in HTTP status code: $httpStatus\n";
    }
    elseif (isset($oToken->error)) {
        print "Error logging into $pmServer:\n" .
            "Error:       {$oToken->error}\n" .
            "Description: {$oToken->description}\n";
    }
    else {
        //Save access token as a cookie that expires in 86400 seconds:
        setcookie("access_token",  $oToken->access_token, time() + 86400);

        //If saving to a file:
        //file_put_contents("/secure/location/oauthAccess.json", json_encode($oToken));
    }
    return $oToken;
}

function pmRestRequest($method, $endpoint, $aVars = null, $accessToken = null) {
    global $pmServer;

    if (empty($accessToken) and isset($_COOKIE['access_token']))
        $accessToken = $_COOKIE['access_token'];

    if (empty($accessToken)) { //if the access token has expired
        //To check if the PM login session has expired: !isset($_COOKIE['PHPSESSID'])
        header("Location: loginForm.php"); //change to match your login method
        die();
    }

    //add beginning / to endpoint if it doesn't exist:
    if (!empty($endpoint) and $endpoint[0] != "/")
        $endpoint = "/" . $endpoint;

    $ch = curl_init($pmServer . $endpoint);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: Bearer " . $accessToken));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $method = strtoupper($method);

    switch ($method) {
        case "GET":
            break;
        case "DELETE":
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
            break;
        case "PUT":
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        case "POST":
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($aVars));
            break;
        default:
            throw new Exception("Error: Invalid HTTP method '$method' $endpoint");
            return null;
    }

    $oRet = new StdClass;
    $oRet->response = json_decode(curl_exec($ch));
    $oRet->status   = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($oRet->status == 401) { //if session has expired or bad login:
        header("Location: loginForm.php"); //change to match your login method
        die();
    }
    elseif ($oRet->status != 200 and $oRet->status != 201) { //if error
        if ($oRet->response and isset($oRet->response->error)) {
            print "Error in $pmServer:\nCode: {$oRet->response->error->code}\n" .
                "Message: {$oRet->response->error->message}\n";
        }
        else {
            print "Error: HTTP status code: $oRet->status\n";
        }
    }

    return $oRet;
}